<?php
// gnre_assina_xml.php
require_once __DIR__ . '/../vendor/autoload.php';

use RobRichards\XMLSecLibs\XMLSecurityDSig;
use RobRichards\XMLSecLibs\XMLSecurityKey;

function assinar_xml_gnre($xml, $pfxPath, $pfxPassword) {
    $pfx = @file_get_contents($pfxPath);
    if (!$pfx) {
        throw new Exception('Certificado PFX não encontrado no caminho informado: ' . $pfxPath);
    }

    if (!openssl_pkcs12_read($pfx, $certs, $pfxPassword)) {
        throw new Exception('Falha ao ler o certificado PFX. Senha incorreta ou arquivo inválido.');
    }

    $privateKey = $certs['pkey'];
    $publicCert = $certs['cert'];

    $dom = new DOMDocument('1.0', 'utf-8');
    $dom->preserveWhiteSpace = false;
    $dom->formatOutput = false;
    $dom->loadXML($xml);

    // Localiza TDadosGNRE (pode estar raíz ou dentro de envelope já)
    $xpath = new DOMXPath($dom);
    $xpath->registerNamespace('gnre', 'http://www.gnre.pe.gov.br');
    $nodeList = $xpath->query('//gnre:TDadosGNRE | //TDadosGNRE');

    if ($nodeList->length == 0) {
        throw new Exception('Tag TDadosGNRE não encontrada no XML para assinar.');
    }
    $elementoAssinar = $nodeList->item(0);

    // Cria assinatura
    $objDSig = new XMLSecurityDSig();
    $objDSig->setCanonicalMethod(XMLSecurityDSig::C14N);

    $objDSig->addReference(
        $elementoAssinar,
        XMLSecurityDSig::SHA1,
        array('http://www.w3.org/2000/09/xmldsig#enveloped-signature')
    );

    $objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA1, array('type'=>'private'));
    $objKey->loadKey($privateKey);
    $objDSig->sign($objKey);

    // adiciona certificado
    $objDSig->add509Cert($publicCert, true, false, array('subjectName' => true));

    // Injeta assinatura dentro do TDadosGNRE
    $objDSig->appendSignature($elementoAssinar);
        
    // Move a assinatura para fora do TLote_GNRE (final do documento)
    $assinatura = $dom->getElementsByTagName('Signature')->item(0);
    if ($assinatura) {
        // Remove assinatura de onde está
        $assinatura->parentNode->removeChild($assinatura);
        // Adiciona a assinatura após o TLote_GNRE
        $root = $dom->getElementsByTagName('TLote_GNRE')->item(0);
        $dom->documentElement->parentNode->appendChild($assinatura);
    }
    
    $xml_assinado = $dom->saveXML();
    $xml_assinado = preg_replace('/ Id="[^"]*"/', '', $xml_assinado);
    return $xml_assinado;

   // return $dom->saveXML();
}
?>
