<?php
function gerar_xml_gnre($dados) {
    $xml = new DOMDocument('1.0', 'UTF-8');
    $xml->formatOutput = true;

    // N raiz
    $root = $xml->createElement('TLote_GNRE');
    $root->setAttribute('xmlns', 'http://www.gnre.pe.gov.br');
    $root->setAttribute('versao', '2.00');
    $xml->appendChild($root);

    // Bloco de guias
    $guias = $xml->createElement('guias');
    $root->appendChild($guias);

    // Guia principal (sem atributo Id)
    $guia = $xml->createElement('TDadosGNRE');
    $guias->appendChild($guia);

    // Campos padr00o
    $campos = [
        'c01_convenio' => '6',
        'c02_receita' => $dados['receita'],
        'c25_detalhamentoReceita' => 'ICMS-ST',
        'c26_produto' => '-',
        'c27_tipoIdentificacaoEmitente' => '1',
        'c28_identificacaoEmitente' => $dados['cnpj_emitente'],
        'c04_razaoSocialEmitente' => $dados['razao_emitente'],
        'c05_referencia' => '',
        'c14_dataVencimento' => $dados['data_vencimento'],
        'c33_dataPagamento' => $dados['data_vencimento'],
        'c16_valorPrincipal' => $dados['valor'],
        'c34_documentoOrigem' => $dados['chave_nfe'],
        'c35_tipoDocOrigem' => '1',
    ];

    foreach ($campos as $tag => $valor) {
        $el = $xml->createElement($tag, htmlspecialchars($valor));
        $guia->appendChild($el);
    }

    // Dados do destinatrio
    $dest = $xml->createElement('c36_idContribuinteDestinatario');
    if (!empty($dados['cpf_dest'])) {
        $dest->appendChild($xml->createElement('CPF', $dados['cpf_dest']));
    } elseif (!empty($dados['cnpj_dest'])) {
        $dest->appendChild($xml->createElement('CNPJ', $dados['cnpj_dest']));
    }

    $dest->appendChild($xml->createElement('razaoSocialDestinatario', $dados['nome_dest']));
    $dest->appendChild($xml->createElement('municipioDestinatario', $dados['cidade_dest']));
    $dest->appendChild($xml->createElement('UF', $dados['uf_dest']));
    $guia->appendChild($dest);

    // Itens GNRE
    $itens = $xml->createElement('itensGNRE');
    $item = $xml->createElement('itemGNRE');
    $item->appendChild($xml->createElement('receita', $dados['receita']));
    $item->appendChild($xml->createElement('tipoValor', '11')); // tipo 11 = valor principal
    $item->appendChild($xml->createElement('valor', $dados['valor']));
    $itens->appendChild($item);
    $guia->appendChild($itens);

    return $xml->saveXML();
}
?>
