<?php
use RobRichards\XMLSecLibs\XMLSecurityKey;
use RobRichards\XMLSecLibs\XMLSecurityDSig;

require_once __DIR__ . '/../vendor/autoload.php';

function enviar_gnre2_soap($signedXml, $pfxPath, $pfxPassword, $ambiente_producao = false)
{
    $endpoint = $ambiente_producao
        ? 'https://www.gnre.pe.gov.br/gnreWS/services/GnreLoteRecepcao'
        : 'https://www.testegnre.pe.gov.br:444/gnreWS/services/GnreLoteRecepcao';

    // 🔹 Remove cabeçalho XML se existir
    $signedXml = preg_replace('/<\?xml.*?\?>/', '', trim($signedXml));

// 🔹 Garante que o namespace da GNRE exista dentro do TLote_GNRE
if (!str_contains($signedXml, 'xmlns="http://www.gnre.pe.gov.br"')) {
    $signedXml = preg_replace(
        '/<TLote_GNRE(.*?)>/',
        '<TLote_GNRE xmlns="http://www.gnre.pe.gov.br"$1>',
        $signedXml
    );
}

    // 🔹 Monta o cabeçalho SOAP conforme WSDL oficial
    $soapEnvelope = '<?xml version="1.0" encoding="UTF-8"?>'
        . '<soap12:Envelope xmlns:soap12="http://www.w3.org/2003/05/soap-envelope" '
        . 'xmlns:gnre="http://www.gnre.pe.gov.br/webservice/GnreLoteRecepcao">'
        . '<soap12:Header>'
        . '<gnre:gnreCabecMsg>'
        . '<gnre:versaoDados>2.00</gnre:versaoDados>'
        . '</gnre:gnreCabecMsg>'
        . '</soap12:Header>'
        . '<soap12:Body>'
        . '<gnre:gnreDadosMsg>'
        . $signedXml
        . '</gnre:gnreDadosMsg>'
        . '</soap12:Body>'
        . '</soap12:Envelope>';

    // 🔹 Log para depuração
    $logDir = __DIR__ . '/../logs/envelope';
    if (!file_exists($logDir)) mkdir($logDir, 0777, true);
    $logFile = $logDir . '/envelope_' . date('Ymd_His') . '.xml';
    file_put_contents($logFile, $soapEnvelope);

    // 🔹 Certificado digital
    $pfx = file_get_contents($pfxPath);
    if (!openssl_pkcs12_read($pfx, $certs, $pfxPassword)) {
        return [
            'sucesso' => false,
            'mensagem' => 'Falha ao ler o certificado PFX.'
        ];
    }

    // 🔹 Configuração cURL
    $ch = curl_init($endpoint);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => [
            'Content-Type: application/soap+xml; charset=utf-8; action="http://www.gnre.pe.gov.br/webservice/GnreLoteRecepcao/processar"'
        ],
        CURLOPT_POSTFIELDS => $soapEnvelope,
        CURLOPT_SSLCERTTYPE => 'P12',
        CURLOPT_SSLCERT => $pfxPath,
        CURLOPT_SSLCERTPASSWD => $pfxPassword,
        CURLOPT_SSL_VERIFYPEER => true,
        CURLOPT_SSL_VERIFYHOST => 2,
        CURLOPT_CONNECTTIMEOUT => 30,
        CURLOPT_TIMEOUT => 60,
        CURLOPT_VERBOSE => true
    ]);

    $response = curl_exec($ch);
    $info = curl_getinfo($ch);
    $errno = curl_errno($ch);
    $error = curl_error($ch);
    curl_close($ch);

    // 🔹 Salva resposta
    $respLog = __DIR__ . '/../logs/retornos/retorno_' . date('Ymd_His') . '.xml';
    if (!file_exists(dirname($respLog))) mkdir(dirname($respLog), 0777, true);
    file_put_contents($respLog, $response ?: $error);

    if ($errno) {
        return [
            'sucesso' => false,
            'mensagem' => "Erro cURL ($errno): $error",
            'endpoint' => $endpoint,
            'log' => $respLog
        ];
    }

    if ($info['http_code'] != 200) {
        return [
            'sucesso' => false,
            'mensagem' => "Falha HTTP {$info['http_code']} ao enviar GNRE",
            'endpoint' => $endpoint,
            'response' => strip_tags($response)
        ];
    }

    return [
        'sucesso' => true,
        'mensagem' => 'GNRE enviada com sucesso!',
        'endpoint' => $endpoint,
        'response' => $response,
        'log' => $respLog
    ];
}
?>
