<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// gnre_envio.php
// Página simples: upload do procNFe.xml, escolha ambiente, processa tudo e exibe retorno.

require_once __DIR__ . '/lib/gnre_monta_xml.php';
require_once __DIR__ . '/lib/gnre_assina_xml.php';

date_default_timezone_set('America/Sao_Paulo');

// CONFIG
$pfxPath = __DIR__ . '/photopaper.pfx'; // ajuste se necessário
$pfxPassword = 'photo008A';

// $endpoint_homolog = 'https://www.testegnre.pe.gov.br/gnreWS/services/GnreLoteRecepcao';
$endpoint_homolog = 'https://www.gnre.pe.gov.br/gnreWS/services/GnreLoteRecepcao';
$endpoint_producao = 'https://www.gnre.pe.gov.br/gnreWS/services/GnreLoteRecepcao';

$log_dir = __DIR__ . '/logs';
if (!is_dir($log_dir)) mkdir($log_dir, 0775, true);
$log_xml_dir = $log_dir . '/xmls_enviados';
if (!is_dir($log_xml_dir)) mkdir($log_xml_dir, 0775, true);
$ret_dir = $log_dir . '/retornos';
if (!is_dir($ret_dir)) mkdir($ret_dir, 0775, true);

// Helper para gravar arquivo
function grava_log($path, $conteudo) {
    file_put_contents($path, $conteudo);
}

// Mostra formulário se GET
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo '<!doctype html><html><head><meta charset="utf-8"><title>Envio GNRE</title></head><body>';
    echo '<h3>Enviar GNRE a partir de procNFe.xml</h3>';
    echo '<form method="post" enctype="multipart/form-data">';
    echo 'Arquivo procNFe (XML): <input type="file" name="procNFe" accept=".xml" required><br><br>';
    echo 'Receita (ex: 100102): <input type="text" name="receita" value="100102" required><br><br>';
    echo '<label><input type="radio" name="ambiente" value="homolog" checked> Homologação</label> ';
    echo '<label><input type="radio" name="ambiente" value="producao"> Produção</label><br><br>';
    echo '<button type="submit">Gerar, Assinar e Enviar</button>';
    echo '</form></body></html>';
    exit;
}

// POST: processamento
try {
    if (!isset($_FILES['procNFe']) || $_FILES['procNFe']['error'] !== UPLOAD_ERR_OK) {
        throw new Exception('Erro no upload do arquivo procNFe.');
    }

    // salva temporário
    $tmp = $_FILES['procNFe']['tmp_name'];
    $orig_name = basename($_FILES['procNFe']['name']);
    $saved_xml = $log_xml_dir . '/' . date('Ymd_His') . '_' . preg_replace('/\W+/', '_', $orig_name);
    if (!move_uploaded_file($tmp, $saved_xml)) {
        // fallback: copy
        if (!copy($tmp, $saved_xml)) throw new Exception('Falha ao salvar arquivo enviado.');
    }

    $receita = $_POST['receita'] ?? '100102';
    $ambiente = ($_POST['ambiente'] ?? 'homolog') === 'producao' ? 'producao' : 'homolog';
    $endpoint = $ambiente === 'producao' ? $endpoint_producao : $endpoint_homolog;

    // 1) monta GNRE (TDadosGNRE)
    $xml_gnre = montar_xml_gnre_automatico($saved_xml, $receita);

    // grava GNRE montado antes de assinar
    $file_gnre_raw = $log_xml_dir . '/gnre_raw_' . date('Ymd_His') . '.xml';
    grava_log($file_gnre_raw, $xml_gnre);

    // 2) assina
    $xml_assinado = assinar_xml_gnre($xml_gnre, $pfxPath, $pfxPassword);

    // grava GNRE assinado
    $file_gnre_signed = $log_xml_dir . '/gnre_signed_' . date('Ymd_His') . '.xml';
    grava_log($file_gnre_signed, $xml_assinado);

    // 3) monta envelope SOAP conforme WSDL (soap 1.2)
    $soap  = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
    $soap .= '<soap12:Envelope xmlns:soap12="http://www.w3.org/2003/05/soap-envelope" xmlns:gnre="http://www.gnre.pe.gov.br/webservice/GnreLoteRecepcao">' . "\n";
    $soap .= '  <soap12:Header>' . "\n";
    $soap .= '    <gnre:gnreCabecMsg>' . "\n";
    $soap .= '      <gnre:versaoDados>2.00</gnre:versaoDados>' . "\n";
    $soap .= '    </gnre:gnreCabecMsg>' . "\n";
    $soap .= '  </soap12:Header>' . "\n";
    $soap .= '  <soap12:Body>' . "\n";
    $soap .= '    <gnre:gnreDadosMsg>' . "\n";
    // Insere o TDadosGNRE assinado (remova possíveis declarações XML duplicadas)
    $xml_assinado_noproc = preg_replace('/^<\?xml.*?\?>\s*/', '', $xml_assinado);
    $soap .= $xml_assinado_noproc . "\n";
    $soap .= '    </gnre:gnreDadosMsg>' . "\n";
    $soap .= '  </soap12:Body>' . "\n";
    $soap .= '</soap12:Envelope>';

    // grava SOAP enviado
    $file_soap = $log_xml_dir . '/soap_to_send_' . date('Ymd_His') . '.xml';
    grava_log($file_soap, $soap);

    // 4) envia via cURL com cliente P12
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $endpoint);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $soap);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "Content-Type: application/soap+xml; charset=utf-8",
    "SOAPAction: \"http://www.gnre.pe.gov.br/webservice/GnreLoteRecepcao/processar\""
    ]);
    
    // Client cert P12 (com senha)
    curl_setopt($ch, CURLOPT_SSLCERTTYPE, 'P12');
    curl_setopt($ch, CURLOPT_SSLCERT, $pfxPath);
    curl_setopt($ch, CURLOPT_SSLKEY, $pfxPath); // alguns servidores exigem
    curl_setopt($ch, CURLOPT_SSLKEYPASSWD, $pfxPassword);
    // TLS
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
    // timeout
    curl_setopt($ch, CURLOPT_TIMEOUT, 60);

    // para debug verbose (remover em produção)
    // curl_setopt($ch, CURLOPT_VERBOSE, true);

    $response = curl_exec($ch);
    $err = curl_error($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // grava retorno
    $ret_file = $ret_dir . '/retorno_' . date('Ymd_His') . '.xml';
    grava_log($ret_file, "HTTP CODE: $http_code\n\n" . ($response ?: $err));

    // exibe ao usuário
    echo '<h3>Resultado do Envio</h3>';
    echo '<pre>';
    if ($response && $http_code >= 200 && $http_code < 300) {
        echo "SUCESSO HTTP $http_code\n\n";
        echo htmlspecialchars($response);
    } else {
        echo "FALHA HTTP $http_code\n\n";
        if ($err) echo "curl error: $err\n\n";
        echo htmlspecialchars($response);
    }
    echo '</pre>';

    echo "<p>Arquivos salvos:</p><ul>";
    echo "<li>GNRE RAW: $file_gnre_raw</li>";
    echo "<li>GNRE SIGNED: $file_gnre_signed</li>";
    echo "<li>SOAP enviado: $file_soap</li>";
    echo "<li>Retorno: $ret_file</li>";
    echo "</ul>";

} catch (Exception $e) {
    echo '<h3>Erro</h3><pre>' . htmlspecialchars($e->getMessage()) . '</pre>';
}
?>
